<?php 
session_start();
ob_start();


function convert_number_to_words($number)
{

    $hyphen      = '-';
    $conjunction = ' and ';
    $separator   = ', ';
    $negative    = 'negative ';
    $decimal     = ' point ';
    $dictionary  = array(
        0                   => 'Zero',
        1                   => 'One',
        2                   => 'Two',
        3                   => 'Three',
        4                   => 'Four',
        5                   => 'Five',
        6                   => 'Six',
        7                   => 'Seven',
        8                   => 'Eight',
        9                   => 'Nine',
        10                  => 'Ten',
        11                  => 'Eleven',
        12                  => 'Twelve',
        13                  => 'Thirteen',
        14                  => 'Fourteen',
        15                  => 'Fifteen',
        16                  => 'Sixteen',
        17                  => 'Seventeen',
        18                  => 'Eighteen',
        19                  => 'Nineteen',
        20                  => 'Twenty',
        30                  => 'Thirty',
        40                  => 'Fourty',
        50                  => 'Fifty',
        60                  => 'Sixty',
        70                  => 'Seventy',
        80                  => 'Eighty',
        90                  => 'Ninety',
        100                 => 'Hundred',
        1000                => 'Thousand',
        1000000             => 'Million',
        1000000000          => 'Billion',
        1000000000000       => 'Trillion',
        1000000000000000    => 'Quadrillion',
        1000000000000000000 => 'Quintillion'
    );

    if (!is_numeric($number)) {
        return false;
    }

    if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {
        // overflow
        trigger_error(
            'convert_number_to_words only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX,
            E_USER_WARNING
        );
        return false;
    }

    if ($number < 0) {
        return $negative . convert_number_to_words(abs($number));
    }

    $string = $fraction = null;

    if (strpos($number, '.') !== false) {
        list($number, $fraction) = explode('.', $number);
    }

    switch (true) {
        case $number < 21:
            $string = $dictionary[$number];
            break;
        case $number < 100:
            $tens   = ((int) ($number / 10)) * 10;
            $units  = $number % 10;
            $string = $dictionary[$tens];
            if ($units) {
                $string .= $hyphen . $dictionary[$units];
            }
            break;
        case $number < 1000:
            $hundreds  = $number / 100;
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) {
                $string .= $conjunction . convert_number_to_words($remainder);
            }
            break;
        default:
            $baseUnit = pow(1000, floor(log($number, 1000)));
            $numBaseUnits = (int) ($number / $baseUnit);
            $remainder = $number % $baseUnit;
            $string = convert_number_to_words($numBaseUnits) . ' ' . $dictionary[$baseUnit];
            if ($remainder) {
                $string .= $remainder < 100 ? $conjunction : $separator;
                $string .= convert_number_to_words($remainder);
            }
            break;
    }

    if (null !== $fraction && is_numeric($fraction)) {
        $string .= $decimal;
        $words = array();
        foreach (str_split((string) $fraction) as $number) {
            $words[] = $dictionary[$number];
        }
        $string .= implode(' ', $words);
    }

    return $string;
}



include("../../../pidbco/pidbjoin.php");

$receipts = strip_tags(base64_decode($_GET['receipts']));
$sq = mysqli_query($con, "SELECT * FROM `p_receipts` WHERE `rid` = '$receipts' ");
$rs = mysqli_fetch_array($sq);

$comid = $rs['rcust'];
$sq1 = mysqli_query($con,"SELECT * FROM `p_customers` WHERE `cid`='$comid' ");
$rs1 = mysqli_fetch_array($sq1); 

$rorder = $rs['rorder'];
$sq2 = mysqli_query($con, "SELECT * FROM `p_orders` WHERE `order_id`='$rorder' ");
$rs2 = mysqli_fetch_array($sq2);

?>
<!DOCTYPE html>
<html>

    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <title>Programers</title>
        
        <style type="text/css">
			table { width:100%; border:none;}
		</style>
        
    </head>

	<body style="font-family:Arial, Helvetica, sans-serif; font-size:11px; margin:0px; padding:10px;">
	
        <div style="width:100%; height:842px; margin:0px auto;">
        	
            <div style="width:95%; min-height:250px; overflow:hidden; border:solid 2px #666666; margin:25px auto;">
            	
                <table>
                <tr>
                	
                    <td style="padding:10px;">
                    	<img src="images/logo.jpg" alt="" />
                    </td>
                    
                    <td style="padding:10px; text-align:right;">
                    	<b style="font-size:12px;">ORIGINAL</b>
                    </td>
                    
                </tr>
                <tr>
                	<td colspan="2" style="text-align:center;">
                    	<b style="font-size:13px;">CASH RECEIPT</b>
                    </td>
                </tr>	
                </table>
                
                <div style="background-color:#000000; color:#FFFFFF; font-weight:bold; line-height:20px; text-align:center; font-size:11px;">
                	PROGRAMERS Web Technologies : 4th Floor, Park House, Round North, Thrissur - 1, Kerala - India.
                </div>
                
                <table>
                <tr>
                	
                    <td style="padding:10px; font-size:12px; font-weight:bold;">
                    	Receipt No. : <span style="color:#FF0000; font-size:16px;"><?php echo $rs['ridentity']; ?></span>
                    </td>
                    
                    <td style="text-align:right; padding:10px; font-size:12px; font-weight:bold;">
                    	Date : <?php echo $rs['rdate']; ?>
                    </td>
                    
                </tr>
                </table>
                
                <div style="line-height:30px; text-align:justify; font-size:12px; padding:10px;">
                	Recevied from Mr. / Ms. / M/s. <span style="font-style:italic; display:inline-block; border-bottom:dotted 1px #666666; padding:0px 5px; margin-right:10px;"><?php echo $rs1['cname']; ?></span> Address <span style="font-style:italic; display:inline-block; border-bottom:dotted 1px #666666; padding:0px 5px; margin-right:10px;"><?php echo $rs1['cdistrict'].",".$rs1['cstate']; ?> </span> The sum of Rupees ( In words ) <span style="font-style:italic; display:inline-block; border-bottom:dotted 1px #666666; padding:0px 5px; margin-right:10px;"><?php echo convert_number_to_words($rs['ramount']).' Rupees Only.';  ?></span> 
                	by <?php if($rs['ramnt_type'] == 'Cash') { ?> Cash <?php } else { ?>cheque, No. <span style="font-style:italic; display:inline-block; border-bottom:dotted 1px #666666; padding:0px 5px; margin-right:10px;"><?php echo $rs['rcheque']; ?></span> Dated <span style="font-style:italic; display:inline-block; border-bottom:dotted 1px #666666; padding:0px 5px; margin-right:10px;"><?php echo $rs['rcheq_date']; ?></span> <?php } ?> Towards <span style="font-style:italic; display:inline-block; border-bottom:dotted 1px #666666; padding:0px 5px; margin-right:10px;"><?php echo $rs2['bill_head']; ?></span>
                    
                </div>
                <br />
                
                <table>
                <tr>
                	
                    <td style="padding:10px;">
                    	
                        <div style="background-color:#EAEAEA; padding:5px; font-size:20px; width:200px;">
                        	Rs. <?php echo number_format($rs['ramount'],2); ?>
                        </div>
                    	
                    </td>
                    
                    <td style="text-align:right; padding:10px; font-size:12px;">
                    	<b>For PROGRAMERS Web Technologies</b><br />
                        <img src="images/signature.jpg" alt="" style="width:75px;" /><br />
                        Authorised Signature
                    </td>
                    
                </tr>
                </table>
                <br />
                
                <div style="background-color:#000000; color:#FFFFFF; font-weight:bold; line-height:20px; font-size:11px; padding:0px 10px;">
                
                	<span style="display:inline-block; text-align:left;">
                    	Mobile : 9447443598, +91 9447151442, +91 9446451442
                    </span>
                    
                    <span style="display:inline-block; float:right;">
                    	url : www.programers.in &nbsp; E-mail : info@programers.in
                    </span>
                    
                </div>
                
                <div style="font-weight:bold; line-height:25px; font-size:11px; text-align:center;">
                
                	* Cheque subject to relaisation &nbsp;&nbsp; * The receipt must be produced when demanded &nbsp;&nbsp; * Amount once paid are not refundable
                    
                </div>
                
            </div>
            <hr style="margin:25px 0px; border-style:dotted;" />
            <div style="width:95%; min-height:250px; overflow:hidden; border:solid 2px #666666; margin:25px auto;">
            	
                <table>
                <tr>
                	
                    <td style="padding:10px;">
                    	<img src="images/logo.jpg" alt="" />
                    </td>
                    
                    <td style="padding:10px; text-align:right;">
                    	<b style="font-size:12px;">DUPLICATE</b>
                    </td>
                    
                </tr>
                <tr>
                	<td colspan="2" style="text-align:center;">
                    	<b style="font-size:13px;">CASH RECEIPT</b>
                    </td>
                </tr>	
                </table>
                
                <div style="background-color:#000000; color:#FFFFFF; font-weight:bold; line-height:20px; text-align:center; font-size:11px;">
                	PROGRAMERS Web Technologies : 4th Floor, Park House, Round North, Thrissur - 1, Kerala - India.
                </div>
                
                <table>
                <tr>
                	
                    <td style="padding:10px; font-size:12px; font-weight:bold;">
                    	Receipt No. : <span style="color:#FF0000; font-size:16px;"><?php echo $rs['ridentity']; ?></span>
                    </td>
                    
                    <td style="text-align:right; padding:10px; font-size:12px; font-weight:bold;">
                    	Date : <?php echo $rs['rdate']; ?>
                    </td>
                    
                </tr>
                </table>
                
                <div style="line-height:30px; text-align:justify; font-size:12px; padding:10px;">
                	Recevied from Mr. / Ms. / M/s. <span style="font-style:italic; display:inline-block; border-bottom:dotted 1px #666666; padding:0px 5px; margin-right:10px;"><?php echo $rs1['cname']; ?></span> Address <span style="font-style:italic; display:inline-block; border-bottom:dotted 1px #666666; padding:0px 5px; margin-right:10px;"><?php echo $rs1['cdistrict'].",".$rs1['cstate']; ?> </span> The sum of Rupees ( In words ) <span style="font-style:italic; display:inline-block; border-bottom:dotted 1px #666666; padding:0px 5px; margin-right:10px;"><?php echo convert_number_to_words($rs['ramount']).' Rupees Only.';  ?></span> 
                	by <?php if($rs['ramnt_type'] == 'Cash') { ?> Cash <?php } else { ?>cheque, No. <span style="font-style:italic; display:inline-block; border-bottom:dotted 1px #666666; padding:0px 5px; margin-right:10px;"><?php echo $rs['rcheque']; ?></span> Dated <span style="font-style:italic; display:inline-block; border-bottom:dotted 1px #666666; padding:0px 5px; margin-right:10px;"><?php echo $rs['rcheq_date']; ?></span> <?php } ?> Towards <span style="font-style:italic; display:inline-block; border-bottom:dotted 1px #666666; padding:0px 5px; margin-right:10px;"><?php echo $rs2['bill_head']; ?></span>
                    
                </div>
                <br />
                
                <table>
                <tr>
                	
                    <td style="padding:10px;">
                    	
                        <div style="background-color:#EAEAEA; padding:5px; font-size:20px; width:200px;">
                        	Rs. <?php echo number_format($rs['ramount'],2); ?>
                        </div>
                    	
                    </td>
                    
                    <td style="text-align:right; padding:10px; font-size:12px;">
                    	<b>For PROGRAMERS Web Technologies</b><br />
                        <img src="images/signature.jpg" alt="" style="width:75px;" /><br />
                        Authorised Signature
                    </td>
                    
                </tr>
                </table>
                <br />
                
                <div style="background-color:#000000; color:#FFFFFF; font-weight:bold; line-height:20px; font-size:11px; padding:0px 10px;">
                
                	<span style="display:inline-block; text-align:left;">
                    	Mobile : 9447443598, +91 9447151442, +91 9446451442
                    </span>
                    
                    <span style="display:inline-block; float:right;">
                    	url : www.programers.in &nbsp; E-mail : info@programers.in
                    </span>
                    
                </div>
                
                <div style="font-weight:bold; line-height:25px; font-size:11px; text-align:center;">
                
                	* Cheque subject to relaisation &nbsp;&nbsp; * The receipt must be produced when demanded &nbsp;&nbsp; * Amount once paid are not refundable
                    
                </div>
                
            </div>
        	
        </div>
	
   
	</body>
    
</html>
